#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Mopi
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2018 BetaRays <array@dotslashplay.it>
set -o errexit

###
# Octodad: Dadliest Catch
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250822.3

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='octodad-dadliest-catch'
GAME_NAME='Octodad: Dadliest Catch'

ARCHIVE_BASE_ITCH_0_NAME='octodad-dadliest-catch-linux.zip'
ARCHIVE_BASE_ITCH_0_MD5='18dd342284a8162ef668e756096038d4'
ARCHIVE_BASE_ITCH_0_SIZE='2971654'
ARCHIVE_BASE_ITCH_0_VERSION='1.2.19351-itch.2020.06.17'
ARCHIVE_BASE_ITCH_0_URL='https://younghorses.itch.io/octodad-dadliest-catch'

ARCHIVE_BASE_HUMBLE_0_NAME='OctodadDadliestCatch1.2.19351.tar.gz'
ARCHIVE_BASE_HUMBLE_0_MD5='df1ded6c02d856a23c2dba919c3be40a'
ARCHIVE_BASE_HUMBLE_0_SIZE='3000000'
ARCHIVE_BASE_HUMBLE_0_VERSION='1.2.19351-humble170512'
ARCHIVE_BASE_HUMBLE_0_URL='https://www.humblebundle.com/store/octodad-dadliest-catch'

CONTENT_PATH_DEFAULT_ITCH='.'
CONTENT_PATH_DEFAULT_HUMBLE='Octodad Dadliest Catch'
CONTENT_LIBS_BIN_FILES='
libfmodevent-4.44.30.so
libfmodex-4.44.30.so'
CONTENT_GAME_BIN_FILES='
OctodadDadliestCatch'
CONTENT_GAME_DATA_FILES='
Content
icon_512x512.png'

USER_PERSISTENT_FILES='
*.odad
*.txt
*.xml'

APP_MAIN_EXE='OctodadDadliestCatch'
APP_MAIN_ICON='icon_512x512.png'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

## Force the use of system-provided SDL.
APP_MAIN_PRERUN="$(application_prerun 'APP_MAIN')
$(launcher_tweak_sdl_override)"
PKG_BIN_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES
libSDL2-2.0.so.0"
## Prevent a game crash when using the wayland backend of SDL.
APP_MAIN_PRERUN="$(application_prerun 'APP_MAIN')"'
# Prevent a game crash when using the wayland backend of SDL
if [ "${SDL_VIDEODRIVER:-}" = "wayland" ]; then
	unset SDL_VIDEODRIVER
fi
'

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
