# /* **************************************************************************
#  *                                                                          *
#  *     (C) Copyright Paul Mensonides 2002.
#  *     Distributed under the Boost Software License, Version 1.0. (See
#  *     accompanying file LICENSE_1_0.txt or copy at
#  *     http://www.boost.org/LICENSE_1_0.txt)
#  *                                                                          *
#  ************************************************************************** */
#
# /* See http://www.boost.org for most recent version. */
#
# include <boost/preprocessor/config/limits.hpp>
# include <boost/preprocessor/arithmetic.hpp>
# include <libs/preprocessor/test/test.h>

/* addition */

BEGIN BOOST_PP_ADD(2, 3) == 5 END

BEGIN BOOST_PP_ADD(BOOST_PP_ADD(2, 2), 2) == 6 END
BEGIN BOOST_PP_ADD(2, BOOST_PP_ADD(1, 4)) == 7 END
BEGIN BOOST_PP_ADD(BOOST_PP_ADD(2, 2), BOOST_PP_ADD(2, 2)) == 8 END

#if BOOST_PP_LIMIT_MAG == 256 && BOOST_PP_CONFIG_FLAGS() & BOOST_PP_CONFIG_STRICT()

BEGIN BOOST_PP_ADD(1, 256) == 256 END
BEGIN BOOST_PP_ADD(256, 1) == 256 END
BEGIN BOOST_PP_ADD(2, 255) == 256 END
BEGIN BOOST_PP_ADD(255, 2) == 256 END
BEGIN BOOST_PP_ADD(1, 255) == 256 END
BEGIN BOOST_PP_ADD(255, 1) == 256 END

#endif

#if BOOST_PP_LIMIT_MAG == 512

BEGIN BOOST_PP_ADD(374, 129) == 503 END

BEGIN BOOST_PP_ADD(1, 512) == 512 END
BEGIN BOOST_PP_ADD(512, 1) == 512 END
BEGIN BOOST_PP_ADD(2, 511) == 512 END
BEGIN BOOST_PP_ADD(511, 2) == 512 END

BEGIN BOOST_PP_ADD(BOOST_PP_ADD(134, 187), 95) == 416 END
BEGIN BOOST_PP_ADD(BOOST_PP_ADD(83, 120), BOOST_PP_ADD(204, 51)) == 458 END
BEGIN BOOST_PP_ADD(149, BOOST_PP_ADD(102, 137)) == 388 END
BEGIN BOOST_PP_ADD(357, BOOST_PP_ADD(102, 137)) == 512 END

#endif

#if BOOST_PP_LIMIT_MAG == 1024

BEGIN BOOST_PP_ADD(732, 188) == 920 END

BEGIN BOOST_PP_ADD(1, 1024) == 1024 END
BEGIN BOOST_PP_ADD(1024, 1) == 1024 END
BEGIN BOOST_PP_ADD(2, 1023) == 1024 END
BEGIN BOOST_PP_ADD(1023, 2) == 1024 END

BEGIN BOOST_PP_ADD(BOOST_PP_ADD(254, 525), 149) == 928 END
BEGIN BOOST_PP_ADD(BOOST_PP_ADD(241, 96), BOOST_PP_ADD(373, 175)) == 885 END
BEGIN BOOST_PP_ADD(792, BOOST_PP_ADD(356, 410)) == 1024 END

#endif

/* subtraction */

BEGIN BOOST_PP_SUB(11, 0) == 11 END
BEGIN BOOST_PP_SUB(12, 1) == 11 END
BEGIN BOOST_PP_SUB(3, 4) == 0 END

BEGIN BOOST_PP_SUB(5, BOOST_PP_SUB(3, 2)) == 4 END
BEGIN BOOST_PP_SUB(BOOST_PP_SUB(10, 5), 2) == 3 END
BEGIN BOOST_PP_SUB(BOOST_PP_SUB(7, 3), BOOST_PP_SUB(10, 8)) == 2 END

#if BOOST_PP_LIMIT_MAG == 256 && BOOST_PP_CONFIG_FLAGS() & BOOST_PP_CONFIG_STRICT()

BEGIN BOOST_PP_SUB(1, 256) == 0 END
BEGIN BOOST_PP_SUB(256, 255) == 1 END

#endif

#if BOOST_PP_LIMIT_MAG == 512

BEGIN BOOST_PP_SUB(315, 412) == 0 END
BEGIN BOOST_PP_SUB(511, 510) == 1 END
BEGIN BOOST_PP_SUB(463, 317) == 146 END
BEGIN BOOST_PP_SUB(272, 195) == 77 END

BEGIN BOOST_PP_SUB(1, 512) == 0 END
BEGIN BOOST_PP_SUB(512, 511) == 1 END

BEGIN BOOST_PP_SUB(371, BOOST_PP_SUB(3, 2)) == 370 END
BEGIN BOOST_PP_SUB(BOOST_PP_SUB(478, 211), 58) == 209 END
BEGIN BOOST_PP_SUB(BOOST_PP_SUB(395, 277), BOOST_PP_SUB(10, 7)) == 115 END
BEGIN BOOST_PP_SUB(BOOST_PP_SUB(412, 383), BOOST_PP_SUB(512, 506)) == 23 END

#endif

#if BOOST_PP_LIMIT_MAG == 1024

BEGIN BOOST_PP_SUB(782, 849) == 0 END
BEGIN BOOST_PP_SUB(1023, 1022) == 1 END
BEGIN BOOST_PP_SUB(654, 538) == 116 END

BEGIN BOOST_PP_SUB(1, 1024) == 0 END
BEGIN BOOST_PP_SUB(1024, 1023) == 1 END

BEGIN BOOST_PP_SUB(829, BOOST_PP_SUB(3, 2)) == 828 END
BEGIN BOOST_PP_SUB(BOOST_PP_SUB(616, 439), 92) == 85 END
BEGIN BOOST_PP_SUB(BOOST_PP_SUB(822, 547), BOOST_PP_SUB(1024, 1011)) == 262 END

#endif

/* multiplication */

BEGIN BOOST_PP_MUL(0, 1) == 0 END
BEGIN BOOST_PP_MUL(1, 0) == 0 END
BEGIN BOOST_PP_MUL(1, 1) == 1 END
BEGIN BOOST_PP_MUL(4, 3) == 12 END

BEGIN BOOST_PP_MUL(BOOST_PP_MUL(2, 2), 2) == 8 END
BEGIN BOOST_PP_MUL(2, BOOST_PP_MUL(2, 2)) == 8 END
BEGIN BOOST_PP_MUL(BOOST_PP_MUL(2, 2), BOOST_PP_MUL(2, 2)) == 16 END

#if BOOST_PP_CONFIG_FLAGS() & BOOST_PP_CONFIG_STRICT()

BEGIN BOOST_PP_MUL(0, BOOST_PP_LIMIT_MAG) == 0 END
BEGIN BOOST_PP_MUL(1, BOOST_PP_LIMIT_MAG) == BOOST_PP_LIMIT_MAG END
BEGIN BOOST_PP_MUL(2, BOOST_PP_LIMIT_MAG) == BOOST_PP_LIMIT_MAG END
BEGIN BOOST_PP_MUL(BOOST_PP_LIMIT_MAG, 0) == 0 END
BEGIN BOOST_PP_MUL(BOOST_PP_LIMIT_MAG, 1) == BOOST_PP_LIMIT_MAG END
BEGIN BOOST_PP_MUL(BOOST_PP_LIMIT_MAG, 2) == BOOST_PP_LIMIT_MAG END

#endif

#if BOOST_PP_LIMIT_MAG == 256 && BOOST_PP_CONFIG_FLAGS() & BOOST_PP_CONFIG_STRICT()

BEGIN BOOST_PP_MUL(17, 17) == 256 END
BEGIN BOOST_PP_MUL(0, 255) == 0 END
BEGIN BOOST_PP_MUL(1, 255) == 255 END
BEGIN BOOST_PP_MUL(2, 255) == 256 END
BEGIN BOOST_PP_MUL(255, 0) == 0 END
BEGIN BOOST_PP_MUL(255, 1) == 255 END
BEGIN BOOST_PP_MUL(255, 2) == 256 END

#endif

#if BOOST_PP_LIMIT_MAG == 512

BEGIN BOOST_PP_MUL(0, 351) == 0 END
BEGIN BOOST_PP_MUL(489, 0) == 0 END
BEGIN BOOST_PP_MUL(1, 272) == 272 END
BEGIN BOOST_PP_MUL(34, 11) == 374 END

BEGIN BOOST_PP_MUL(BOOST_PP_MUL(7, 7), 7) == 343 END
BEGIN BOOST_PP_MUL(7, BOOST_PP_MUL(7, 7)) == 343 END
BEGIN BOOST_PP_MUL(BOOST_PP_MUL(5, 5), BOOST_PP_MUL(4, 4)) == 400 END

BEGIN BOOST_PP_MUL(24, 24) == 512 END
BEGIN BOOST_PP_MUL(0, 511) == 0 END
BEGIN BOOST_PP_MUL(1, 511) == 511 END
BEGIN BOOST_PP_MUL(2, 511) == 512 END
BEGIN BOOST_PP_MUL(511, 0) == 0 END
BEGIN BOOST_PP_MUL(511, 1) == 511 END
BEGIN BOOST_PP_MUL(511, 2) == 512 END

#endif

#if BOOST_PP_LIMIT_MAG == 1024

BEGIN BOOST_PP_MUL(0, 653) == 0 END
BEGIN BOOST_PP_MUL(926, 0) == 0 END
BEGIN BOOST_PP_MUL(1, 849) == 849 END
BEGIN BOOST_PP_MUL(42, 17) == 714 END

BEGIN BOOST_PP_MUL(BOOST_PP_MUL(9, 9), 9) == 729 END
BEGIN BOOST_PP_MUL(9, BOOST_PP_MUL(9, 9)) == 729 END
BEGIN BOOST_PP_MUL(BOOST_PP_MUL(6, 6), BOOST_PP_MUL(5, 5)) == 900 END

BEGIN BOOST_PP_MUL(35, 35) == 1024 END
BEGIN BOOST_PP_MUL(0, 1024) == 0 END
BEGIN BOOST_PP_MUL(1, 1024) == 1024 END
BEGIN BOOST_PP_MUL(2, 1024) == 1024 END
BEGIN BOOST_PP_MUL(1023, 0) == 0 END
BEGIN BOOST_PP_MUL(1023, 1) == 1023 END
BEGIN BOOST_PP_MUL(1023, 2) == 1024 END

#endif

/* division */

BEGIN BOOST_PP_DIV(2, 1) == 2 END
BEGIN BOOST_PP_DIV(0, 5) == 0 END
BEGIN BOOST_PP_DIV(7, 3) == 2 END

BEGIN BOOST_PP_DIV(BOOST_PP_DIV(4, 2), 2) == 1 END
BEGIN BOOST_PP_DIV(10, BOOST_PP_DIV(10, 2)) == 2 END
BEGIN BOOST_PP_DIV(BOOST_PP_DIV(10, 2), BOOST_PP_DIV(4, 2)) == 2 END

#if BOOST_PP_LIMIT_MAG == 512

BEGIN BOOST_PP_DIV(468, 3) == 156 END
BEGIN BOOST_PP_DIV(0, 272) == 0 END
BEGIN BOOST_PP_DIV(335, 6) == 55 END

BEGIN BOOST_PP_DIV(BOOST_PP_DIV(498, 2), 2) == 124 END
BEGIN BOOST_PP_DIV(375, BOOST_PP_DIV(279, 3)) == 4 END
BEGIN BOOST_PP_DIV(BOOST_PP_DIV(486, 2), BOOST_PP_DIV(17, 4)) == 60 END

#endif

#if BOOST_PP_LIMIT_MAG == 1024

BEGIN BOOST_PP_DIV(849, 36) == 23 END
BEGIN BOOST_PP_DIV(0, 638) == 0 END
BEGIN BOOST_PP_DIV(467, 17) == 27 END

BEGIN BOOST_PP_DIV(BOOST_PP_DIV(1004, 10), 5) == 20 END
BEGIN BOOST_PP_DIV(593, BOOST_PP_DIV(925, 25)) == 16 END
BEGIN BOOST_PP_DIV(BOOST_PP_DIV(746, 12), BOOST_PP_DIV(848, 424)) == 31 END

#endif

/* modulus */

BEGIN BOOST_PP_MOD(5, 5) == 0 END
BEGIN BOOST_PP_MOD(9, 5) == 4 END
BEGIN BOOST_PP_MOD(7, 4) == 3 END

BEGIN BOOST_PP_MOD(BOOST_PP_MOD(5, 3), 3) == 2 END
BEGIN BOOST_PP_MOD(5, BOOST_PP_MOD(4, 3)) == 0 END

#if BOOST_PP_LIMIT_MAG == 512

BEGIN BOOST_PP_MOD(473, 473) == 0 END
BEGIN BOOST_PP_MOD(381, 126) == 3 END
BEGIN BOOST_PP_MOD(262, 27) == 19 END

BEGIN BOOST_PP_MOD(BOOST_PP_MOD(368, 65), 7) == 1 END
BEGIN BOOST_PP_MOD(194, BOOST_PP_MOD(411, 205)) == 0 END

#endif

#if BOOST_PP_LIMIT_MAG == 1024

BEGIN BOOST_PP_MOD(831, 831) == 0 END
BEGIN BOOST_PP_MOD(935, 73) == 59 END
BEGIN BOOST_PP_MOD(610, 84) == 22 END

BEGIN BOOST_PP_MOD(BOOST_PP_MOD(732, 27), 2) == 1 END
BEGIN BOOST_PP_MOD(1023, BOOST_PP_MOD(544, 29)) == 11 END

#endif

/* increment */

BEGIN BOOST_PP_INC(0) == 1 END
BEGIN BOOST_PP_INC(22) == 23 END
BEGIN BOOST_PP_INC(BOOST_PP_INC(0)) == 2 END
BEGIN BOOST_PP_INC(BOOST_PP_INC(17)) == 19 END

#if BOOST_PP_LIMIT_MAG == 256

BEGIN BOOST_PP_INC(256) == 256 END
BEGIN BOOST_PP_INC(BOOST_PP_INC(255)) == 256 END

#endif

#if BOOST_PP_LIMIT_MAG == 512

BEGIN BOOST_PP_INC(349) == 350 END
BEGIN BOOST_PP_INC(426) == 427 END
BEGIN BOOST_PP_INC(256) == 257 END
BEGIN BOOST_PP_INC(BOOST_PP_INC(505)) == 507 END
BEGIN BOOST_PP_INC(BOOST_PP_INC(272)) == 274 END
BEGIN BOOST_PP_INC(BOOST_PP_INC(255)) == 257 END

#endif

#if BOOST_PP_LIMIT_MAG == 1024

BEGIN BOOST_PP_INC(593) == 594 END
BEGIN BOOST_PP_INC(821) == 822 END
BEGIN BOOST_PP_INC(512) == 513 END
BEGIN BOOST_PP_INC(BOOST_PP_INC(924)) == 926 END
BEGIN BOOST_PP_INC(BOOST_PP_INC(732)) == 734 END
BEGIN BOOST_PP_INC(BOOST_PP_INC(511)) == 513 END

#endif

/* decrement */

BEGIN BOOST_PP_DEC(256) == 255 END
BEGIN BOOST_PP_DEC(47) == 46 END
BEGIN BOOST_PP_DEC(0) == 0 END

BEGIN BOOST_PP_DEC(BOOST_PP_DEC(256)) == 254 END
BEGIN BOOST_PP_DEC(BOOST_PP_DEC(85)) == 83 END
BEGIN BOOST_PP_DEC(BOOST_PP_DEC(1)) == 0 END

#if BOOST_PP_LIMIT_MAG == 512

BEGIN BOOST_PP_DEC(257) == 256 END
BEGIN BOOST_PP_DEC(473) == 472 END
BEGIN BOOST_PP_DEC(512) == 511 END

BEGIN BOOST_PP_DEC(BOOST_PP_DEC(257)) == 255 END
BEGIN BOOST_PP_DEC(BOOST_PP_DEC(329)) == 327 END
BEGIN BOOST_PP_DEC(BOOST_PP_DEC(512)) == 510 END

#endif

#if BOOST_PP_LIMIT_MAG == 1024

BEGIN BOOST_PP_DEC(1025) == 1024 END
BEGIN BOOST_PP_DEC(770) == 769 END
BEGIN BOOST_PP_DEC(1024) == 1023 END

BEGIN BOOST_PP_DEC(BOOST_PP_DEC(1025)) == 1023 END
BEGIN BOOST_PP_DEC(BOOST_PP_DEC(959)) == 957 END
BEGIN BOOST_PP_DEC(BOOST_PP_DEC(1024)) == 1022 END

#endif
