libkdumpfile
============

Kernel coredump file access

To compile this package, you'll need the following:

* [zlib](http://www.zlib.net/). You can usually find it in a zlib-devel
  package.
* [lzo](http://www.oberhumer.com/opensource/lzo/). Often found in a
  lzo-devel package.
* [snappy](https://github.com/google/snappy). Often found in a snappy-devel
   package.
* [libzstd](https://github.com/facebook/zstd). Often found in a libzstd-devel
  package.
* [GNU C Library](http://www.gnu.org/software/libc/libc.html). Almost
  any version will do. Other C libraries may also work, but since there
  is no standard interface for byte-order macros, this may need some porting.
* [GCC](http://gcc.gnu.org/). The source uses a few construct specific
  to GCC (such as variable attributes). Porting should be easy, though.

If you want to build kdumpid, you'll also need:

* [BFD](http://www.gnu.org/software/binutils/). Any version with
  disassemblers for x86, ppc and s390 will do. This usually comes with
  the distro packaged as binutils-devel or similar.

To create documentation files, you'll need:

* [Doxygen](http://www.doxygen.org/). Usually packaged as doxygen.

Once you've got the prerequisites, simply unpack the tarball and run


	./configure
	make
	make install

To generate documentation files, run:

	make doxygen-doc

If you updated directly from git, there is no `configure` script. That's
becuase this script itself is generated by autoconf. To bootstrap this
project from scratch, you will need:

* [autoconf](https://www.gnu.org/software/autoconf/)
* [automake](https://www.gnu.org/software/automake/)
* [libtool](https://www.gnu.org/software/libtool/)
* [pkg-config](https://www.freedesktop.org/wiki/Software/pkg-config/)

To generate the `configure` script, run

	autoreconf -fi

Python
------

This repository contains some manually written Python bindings. These are now
deprecated in favour of a fresh rewrite using CFFI. See
[pykdumpfile](https://github.com/ptesarik/pykdumpfile).

Making Releases
---------------

To make a new public release:

1. Make sure that the NEWS file is updated with all important changes
2. Update the version information:
    * configure.ac: update `pkg_version_*` macros
    * src/Makefile.am: libtool versioning (see Libtool info file)
    * src/addrxlat/Makefile.am: addrxlat libtool versioning

3. Make a new commit ("Prepare release x.y.z")
4. Run `make distcheck`
5. Create a signed tag using `git tag -s`
6. Upload the tarballs to GitHub and create a new release
7. Write an announcement
